/*****************************************************************************
 *   uart.h:  Header file for NXP LPC31xx Family Microprocessors
 *
 *   Copyright(C) 2007, NXP Semiconductor
 *   All rights reserved.
 *
 *   History
 *   2007.09.01  ver 1.00    Preliminary version, first Release
 *
 ****************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 *****************************************************************************/
 
#ifndef __UART_H 
#define __UART_H

#define UART_DMA_ENABLE		1
#define UART0TIMEOUTVALUE	5

/* Standard UART bit definition */
#define IER_RBR		0x01
#define IER_THRE	0x02
#define IER_RLS		0x04

#define IIR_RLS		0x03
#define IIR_RDA		0x02
#define IIR_CTI		0x06
#define IIR_THRE	0x01

#define LSR_RDR		0x01
#define LSR_OE		0x02
#define LSR_PE		0x04
#define LSR_FE		0x08
#define LSR_BI		0x10
#define LSR_THRE	0x20
#define LSR_TEMT	0x40
#define LSR_RXFE	0x80

#define BUFSIZE		0x40

void UART0Init( DWORD Baudrate );
void UART1Init( DWORD Baudrate );
void UART0Handler( void );
void UART1Handler( void );
void UART0Send( BYTE *BufferPtr, DWORD Length );
void UART0SendString(BYTE *p);
void UART0SendChar(BYTE b);
void UART1Send( BYTE *BufferPtr, DWORD Length );

#endif /* end __UART_H */
/*****************************************************************************
**                            End Of File
******************************************************************************/
